package gov.va.med.mhv.usermgmt.web.controller;

import java.io.IOException;
import java.io.Serializable;

import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.CommonUtility;
import gov.va.med.mhv.usermgmt.common.dto.UserPasswordUpdatedTimeDTO;
import gov.va.med.mhv.usermgmt.web.formbean.ChangePassword;


@ManagedBean
@Component
@Scope(WebApplicationContext.SCOPE_REQUEST)
public class ChangePasswordController extends AbstractController implements Serializable {

	private static final long serialVersionUID = -9191875686222494443L;

	static Log logger = LogFactoryUtil.getLog(ChangePasswordController.class);

	@Autowired
	private ChangePassword changePassword;

	private String successMessage = null;
	
	private Boolean temporaryPasswordFlag;
	private String  date;
	private String time;
	private static final String DATE_FORMAT="dd MMMM yyyy";
	private static final String TIME_FORMAT="hh:mm a";
	//Delegation
	private boolean readOnlyMode = false;
	private static final String DELEGATE_ACCESS = "LIFERAY_SHARED_delegatee_access";
	private static final String READ_ACCESS = "READ";
	private static final String FULL_ACCESS = "FULL";
	
	// Initial entry
	public void authorize() throws IOException{

		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();

		if (request.getUserPrincipal() == null) {
			FacesContext context = FacesContext.getCurrentInstance();
			context.getApplication().getNavigationHandler().handleNavigation(context, null, "uanuthorized.xhtml");
		}
		Long userprofileId=getUserProfileId();
		UserPasswordUpdatedTimeDTO userPasswordUpdatedTimeDTO;
		try {
			userPasswordUpdatedTimeDTO = userMgmtService.getUserPasswordUpdatedDetails(userprofileId);

			readOnlyMode = false;
			// set readOnlyMode to true for HPRA
			Object obj=null;
			PortletSession session = request.getPortletSession();
			obj = session.getAttribute(DELEGATE_ACCESS, PortletSession.APPLICATION_SCOPE);
			if (logger.isDebugEnabled()) {
				logger.debug("delegateAccess obj Value: " + obj);
			}
			if(obj != null){
				String delegateAccess = (String)obj;

				if (logger.isDebugEnabled()) {
					logger.debug("delegateAccess value: " + delegateAccess);
				}
				if(delegateAccess.equalsIgnoreCase(READ_ACCESS) || delegateAccess.equalsIgnoreCase(FULL_ACCESS))
					readOnlyMode = true;
			}			
			setTemporaryPasswordFlag(userPasswordUpdatedTimeDTO.getTempPasswordFlag());
			if(temporaryPasswordFlag){
				setDate(CommonUtility.dateToString(userPasswordUpdatedTimeDTO.getUpdatedTime(), DATE_FORMAT));
				setTime(CommonUtility.dateToString(userPasswordUpdatedTimeDTO.getUpdatedTime(), TIME_FORMAT));
			}
			if(getSuccessMessage()==null )
					setSuccessMessage("");
		} catch (MHVException e) {
			super.processErrorMessages(e);
		}
		
	}

	public String updatePassword() {
		FacesContext context = FacesContext.getCurrentInstance();

		PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
		PortletSession session = request.getPortletSession();
		HttpSession sess=PortalSessionThreadLocal.getHttpSession();

		String userid = (String) session.getAttribute("LIFERAY_SHARED_userid", PortletSession.APPLICATION_SCOPE);
		UserProfileDTO userProfile = getUserProfile(userid);
		userProfile.setPassword(this.changePassword.getNewPassword());

		userProfile.setConfPassword(this.changePassword.getConfirmNewPassword());
		userProfile.setOldPassword(this.changePassword.getCurrentPassword());
		validatePassword(userProfile,true);
		
		if( FacesContext.getCurrentInstance().getMessageList().size() > 0 ) {
			context.getApplication().getNavigationHandler().
	        handleNavigation(context, null, "/views/account/changePassword.xhtml");
			return null;
		}

		try {
			this.userMgmtService.changePassword(userProfile,Boolean.FALSE);
			this.setSuccessMessage("success");
			if(sess.getAttribute(ATTR_REDIRECT_PATH)!=null)
				sess.removeAttribute(ATTR_REDIRECT_PATH);
		} catch (MHVException e) {
			super.processErrorMessages(e);
			return null;
		} catch (Exception e) {
			this.setSuccessMessage("failure");
			logger.error(e);
		}

		context.getApplication().getNavigationHandler().
        handleNavigation(context, null, "/views/account/changePassword.xhtml");
		
		return null;
	}


	public String getDate() {
		return date;
	}

	public void setDate(String date) {
		this.date = date;
	}

	public String getTime() {
		return time;
	}

	public void setTime(String time) {
		this.time = time;
	}

	public Boolean getTemporaryPasswordFlag() {
		return temporaryPasswordFlag;
	}

	public void setTemporaryPasswordFlag(Boolean temporaryPasswordFlag) {
		this.temporaryPasswordFlag = temporaryPasswordFlag;
	}
	
	public ChangePassword getChangePassword() {
		return changePassword;
	}

	public String getSuccessMessage() {
		return successMessage;
	}

	public void setSuccessMessage(String successMessage) {
		this.successMessage = successMessage;
	}
	
	public boolean isReadOnlyMode() {
		return readOnlyMode;
	}

	public void setReadOnlyMode(boolean readOnlyMode) {
		this.readOnlyMode = readOnlyMode;
	}	
	
}